#!/usr/bin/perl
# lun ago  8 14:37:00 CEST 2005
# author: Pedro Larroy Tovar
#
#
# This script extracts $MAXPICS pictures from the videos for face 
# recognition.

use warnings;
use strict;
use File::Find;
use File::Copy;
use Getopt::Long;
use POSIX;

############################################################
# TUNABLES: 
#
# Extension of the video streams
#

my $EXT='avi';

#
# We only keep multiples of PICEACH pictures, in order not to get 
# consecutive frames.
#

my $PICEACH=2;

#
# In the end we only keep this many pictures
#

my $MAXPICS=50;

#
###########################################################


# Extension of the pics (don't change), mplayer only support a subset of picture extensions
#
my $PICEXT='png';

die '$EXT can\'t be equal to $PICEXT'."\n" if ($EXT eq $PICEXT);



my %opt;

sub usage {
die<<EOT;
$0 usage:
	$0 [options] directory1 [directory2] ...

	options:
		--help		this screen
		--overwrite	overwrites the streams
		--verbose	shows mplayer output


EOT
}

sub disable_stdout_stderr {
	no warnings;
	open(OLDSTDOUT,">&STDOUT") or die "Open:$!";
	open(OLDSTDERR,">&STDOUT") or die "Open:$!";
	open(FNULL,'>/dev/null') or die "open: $!";	
	open(STDERR,">&FNULL") or die "open: $!";
	open(STDOUT,">&FNULL") or die "open: $!";

}

sub enable_stdout_stderr {
	no warnings;
	close(STDERR) or die "close: $!";
	close(STDOUT) or die "close: $!";
	close(FNULL) or die "close: $!";
	open(STDERR,">&OLDSTDERR") or die "open: $!";
	open(STDOUT,">&OLDSTDOUT") or die "open: $!";
}

sub found {
	if ( -f $_ && m/^(.*)\.\Q$EXT\E$/ ) {
		my $prefix = $1;
		my @pics=<*.$PICEXT>;

		#######
		#
		# Detect that a picture number $MAXPICS exist for this video
		# 
		my @match = grep( /^\Q$prefix\E-0*\Q$MAXPICS\E\.png/, @pics);
		if (@match) {
			print join(' ',@match)."\n";
			print "$_ is already done\n" if $opt{verbose};
			return if (!$opt{overwrite});
		}
		#######
		
#		if ( -f $prefix."-".sprintf("%0".length($MAXPICS)."d",$MAXPICS).".png" ) {
#			print "$_ is already done\n" if $opt{verbose};
#			return if (!$opt{overwrite});
#		} elsif ( -r $_ ) {
		if( -r $_) {
			#my @CMD = ('mplayer','-really-quiet','-ao','pcm:file='.$dumpfile,'-vo','null',$_);			
			my @CMD = ('mplayer','-really-quiet','-frames',ceil($MAXPICS*$PICEACH),'-ao','null','-vo','png:z=0',$_);			
			print "processing: $_\n" if $opt{verbose};
			disable_stdout_stderr;
			system(@CMD) == 0 or die join(' ',@CMD).": $!";
			enable_stdout_stderr;
			opendir(DIR,".") or die "opendir: $!";

			my $i=0;
			my $kept=0;
			#
			# Files are saved by mplayer like 00000001.png, so we move them to a 
			# more meaningful file name composed with the name of the video file 
			# without the extension, plus a number ($kept), which is formated with
			# leading zeros as necesary for practical purposes.
			#
			while($_=readdir(DIR)) {
				if ( -f $_ && m/^(\d+)\.\Q$PICEXT\E$/ ) {
					print "Matched $_\n";
					if ( $kept >= $MAXPICS ) {
						unlink($_);
					} elsif ( ($i % $PICEACH)) {
						if ( -w $_ ) {
							unlink($_) or die "unlink: $!";
							print "unlink $_\n" if $opt{verbose};
							#print "unlink $_\n";
						} else {
							die $_.": not writable, skipping";
						}
					} else {
						# 
						# Move the file to the definitive name
						#
						my $fmt_kept = sprintf("%0".length($MAXPICS)."d",$kept);
						move($_,$prefix.'-'.$fmt_kept.'.'.$PICEXT) or die "move: $!";
						print "move $_ to $prefix-$fmt_kept.$PICEXT\n" if $opt{verbose};
						$kept++;
					}
					$i++;
				}
			}

			closedir(DIR) or die "closedir: $!";
			print "done\n";
		} else {
			warn $_.": not readable";
		}
	}
}

GetOptions(
	'help' => \$opt{help},
	'verbose+' => \$opt{verbose},
	'overwrite' => \$opt{overwrite},
) or usage;
usage if $opt{help};

if ( ! @ARGV ) {
	usage();
}
foreach my $arg (@ARGV) {
	if ( ! -d $arg ) {
		die "$arg: not a directory, see usage";
	}
}

find(\&found,@ARGV);




